﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Domaine
{
    /// <summary>
    /// Modélise un emprunt d'un livre par un utilisateur
    /// </summary>
    public class Emprunt
    {
        private DateTime date;
        private bool rendu;
        private Utilisateur emprunteur;
        private Livre livre;

        /// <summary>
        /// Constructeur
        /// </summary>
        /// <param name="emprunteur"></param>
        /// <param name="livre"></param>
        public Emprunt(Utilisateur emprunteur, Livre livre)
        {
            this.emprunteur = emprunteur;
            this.livre = livre;
            date = DateTime.Now;
            rendu = false;
        }

        public Emprunt(Utilisateur emprunteur, Livre livre, DateTime date)
        {
            this.emprunteur = emprunteur;
            this.livre = livre;
            this.date = date;
            rendu = false;
        }

        /// <summary>
        /// Date de l'emprunt
        /// </summary>
        public DateTime Date
        {
            get { return date; }
            set { date = value; }
        }

        /// <summary>
        /// L'emprunt est-il déjà rendu ?
        /// </summary>
        public bool Rendu
        {
            get { return rendu; }
            set { rendu = value; }
        }

        /// <summary>
        /// Utilisateur qui a emprunté le livre
        /// </summary>
        public Utilisateur Emprunteur
        {
            get { return emprunteur; }
            set { emprunteur = value; }
        }

        /// <summary>
        /// Livre emprunté
        /// </summary>
        public Livre Livre
        {
            get { return livre; }
            set { livre = value; }
        }

        /// <summary>
        /// Décrit un emprunt
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return Emprunteur.ToString() + " - " + Livre.Titre;
        }
    }
}
